/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.clock;

import emulator.hardware.clock.ClockHandle;
import emulator.hardware.clock.ClockImplementation;
import emulator.util.Handle;

public class ClockHandleImplementation
extends Handle
implements ClockHandle {
    private int max_ticks = 1;
    private int ticks_elapsed = 0;
    private ClockImplementation clock;

    ClockHandleImplementation(ClockImplementation clock) {
        this.clock = clock;
    }

    ClockHandleImplementation(ClockImplementation clock, int max_ticks) {
        this.clock = clock;
        this.max_ticks = max_ticks;
    }

    @Override
    public void tick() {
        this.tick(1);
    }

    @Override
    public void tick(int x) {
        this.ticks_elapsed += x;
        if (this.ticks_elapsed >= this.max_ticks) {
            this.clock.countTicks(this, this.ticks_elapsed);
            this.ticks_elapsed = 0;
        }
    }

    @Override
    public long getTicks() {
        return this.clock.getTicks();
    }
}

